#include <Elementary.h>

/* 
* To compile:
* cc -o knob-demo knob-demo.c $(pkg-config --cflags elementary) $(pkg-config --libs elementary) 
*/

/* The Elementary widgets/containers: */
static Evas_Object *win;
static Evas_Object *box, *knob, *label;

static float knob_value = 0.5;

static void on_done(void *data, Evas_Object *obj, void *event_info)
{
   /* quit the mainloop (elm_run function will return) */
   elm_exit();
}

/* This fnction is called when the knob/slider is dragged */
static void knob_fun(void *data, Evas_Object *obj, void *event_info)
{
   knob_value = elm_slider_value_get(obj);
   char label_text[20];
   snprintf(label_text, 20*sizeof(char), "%f", knob_value);
   elm_object_text_set(label, label_text);
}

EAPI_MAIN int elm_main(int argc, char **argv)
{

   /* THE WINDOW */
   win = elm_win_add(NULL, "KNOBDEMO", ELM_WIN_BASIC);
   elm_win_title_set(win, "Knob");
   evas_object_smart_callback_add(win, "delete,request", on_done, NULL);

   /* BOX FOR THE THINGS */
   box = elm_box_add(win);
   elm_box_horizontal_set(box, EINA_TRUE);
   elm_win_resize_object_add(win, box);
   evas_object_show(box);

   /* THE KNOB SLIDER */
   elm_theme_extension_add(NULL, "./knob.edj");
   knob = elm_slider_add(win);
   elm_object_style_set(knob, "knob");
   elm_slider_horizontal_set(knob, EINA_TRUE);
   elm_slider_unit_format_set(knob, "%1.2f vol");
   elm_slider_min_max_set(knob, 0.0, 1.5);
   elm_slider_span_size_set(knob, 180);
   evas_object_smart_callback_add(knob, "delay,changed", knob_fun, NULL);    
   elm_slider_value_set(knob, knob_value);
   elm_box_pack_end(box, knob);
   evas_object_show(knob);

   /* LABEL TO SHOW KONB VALUE */
   label = elm_label_add(win);
   char label_text[20];
   snprintf(label_text, 20*sizeof(char), "%f", knob_value);
   elm_object_text_set(label, label_text);
   elm_box_pack_end(box, label);
   evas_object_show(label);

   evas_object_show(win);
   elm_run();
   elm_shutdown();
   return 0;

}
ELM_MAIN()
